#pragma rtGlobals=1		// Use modern global access method.
#pragma version=3.1

// ******** MPR 2 Band *******

Function MPR2BandReset()
	MPR2BandSetupDesign()
	SetAxis/A/Z bottom			// in case user set a manual X axis range
	Execute "m2bComputeButton(\"\")"
End

Function ButtonMPR2Band(ctrlName) : ButtonControl
	String ctrlName
	
	DoWindow/F WMMPR2BandDesign
	if( V_Flag==0 )
		MPR2BandSetupDesign()
	endif
End

Function MPR2BandSetupDesign()

	SetApplyButtonTitle(0)

	NVAR fs= root:Packages:WM_IFDL:fs

	String dfSav= Set_IFDL_DataFolder()
	
	Variable lphp=NumVarOrDefault("m2b_lphp",1)
	Variable nt=NumVarOrDefault("m2b_n",41)
	Variable b1end=NumVarOrDefault("m2b_b1e",0.3)
	Variable b2start=NumVarOrDefault("m2b_b2s",0.4)
	Variable b1weight=NumVarOrDefault("m2b_b1w",1)

	// Create the globals
	Variable/G m2b_lphp=lphp
	Variable/G m2b_n=nt
	Variable/G m2b_b1e=b1end
	Variable/G m2b_b2s=b2start
	Variable/G m2b_b1w=b1weight

	// scale the saved normalized frequencies for the SetVariable controls
	Variable/G m2b_b1e_fs= b1end * fs
	Variable/G m2b_b2s_fs= b2start * fs

	SetDataFolder dfSav

	MPR2BandUpdate()
	CreateMPR2BandDesign()
	MPR2BandUpdate()			// set the control limits, too.
End

// update waves that show the MPR 2 Band design parameters
// This is called whenever any parameters change.
Function MPR2BandUpdate()

	NVAR fs= root:Packages:WM_IFDL:fs

	String dfSav= Set_IFDL_DataFolder()
	Variable lphp= NumVarOrDefault("m2b_lphp",1)
	Variable nt= NumVarOrDefault("m2b_n",41)
	Variable b1weight= NumVarOrDefault("m2b_b1w",1)

	Variable b1endFs= NumVarOrDefault("m2b_b1e_fs",0.3 * fs)
	Variable b2startFs=NumVarOrDefault("m2b_b2s_fs",0.4 * fs)

	// Save the normalized frequencies in case the user changes sampling frequency
	Variable/G m2b_b1e= b1endFs/fs
	Variable/G m2b_b2s= b2startFs/fs

	Variable isLowPass= lphp == 1
	
	// Passband and stop band response pair, linear response
	Make/O m2b_responseX = {0,b1endFs,NaN,b2startFs,fs*0.5}
	Make/O m2b_response  = {isLowPass,isLowPass,NaN,!isLowPass,!isLowPass}	// updated by DesiredFromActualResponse

	Variable eps= abs(b1EndFs - b2startFS)/8
	DesiredFromActualResponse(m2b_response,"WMMPR2BandDesign",b1endFs,b2startFs,0,0,isLowPass,eps)
	
	// transition region waves
	Make/O     m2b_transitionX = {m2b_responseX[1],m2b_responseX[3]}
	Make/O/N=2 m2b_transitionPlus =  max(m2b_response[0],m2b_response[3])
	Make/O/N=2 m2b_transitionMinus = min(m2b_response[0],m2b_response[3])

	DoWindow WMMPR2BandDesign
	if( V_Flag == 1 ) // don't allow the end of the pass band to exceed the start of the stop band
		ControlInfo/W=WMMPR2BandDesign m2b_b1e
		Variable band1End= V_Value
		ControlInfo/W=WMMPR2BandDesign m2b_b2s
		Variable band2Start= V_Value

		Variable df=  NiceNumber(fs/200)
		// don't let band 1 end after the start of band 2
		Variable end1Max= max(band1End,band2Start)
		end1Max= limit(end1Max,0,fs/2)
		
		SetVariable m2b_b1e,limits={0,end1Max,df},win=WMMPR2BandDesign
		
		// don't let band 2 start before the end of band 1
		Variable start2Min= min(band1End,band2Start)
		start2Min= limit(start2Min,0, fs/2)
		SetVariable m2b_b2s,limits={start2Min,fs/2,df},win=WMMPR2BandDesign

		ControlUpdate/A/W=WMMPR2BandDesign
	endif
	SetDataFolder dfSav
End

Function CreateMPR2BandDesign()
	
	if( DesignGraph("WMMPR2BandDesign","MPR 2 Band Design") )
		return 1	// already existed, don't reset the graph settings.
	endif

	NVAR fs= root:Packages:WM_IFDL:fs
	NVAR lphp= root:Packages:WM_IFDL:m2b_lphp	// see PopupMenu m2b_lphp, below
	String typeList= "low pass;high pass"
	String popMenuValue= GetStrFromList(typeList, lphp, ";")
	Variable df= NiceNumber(fs/200)	// 1,2,5 increment for SetVariable controls

	String dfSav= Set_IFDL_DataFolder()
	AppendToGraph/L=responseLeft m2b_transitionPlus,m2b_transitionMinus vs m2b_transitionX
	AppendToGraph/L=responseLeft m2b_response vs m2b_responseX
	SetDataFolder dfSav

	ModifyGraph mode(m2b_transitionPlus)=7
	ModifyGraph lSize(m2b_transitionPlus)=0,lSize(m2b_transitionMinus)=0
	ModifyGraph rgb(m2b_transitionPlus)=(56797,56797,56797)
	ModifyGraph hbFill(m2b_transitionPlus)=2
	ModifyGraph toMode(m2b_transitionPlus)=1

	ModifyGraph lblPos(responseLeft)=60
	ModifyGraph freePos(responseLeft)={0,bottom}
	ModifyGraph margin(left)=67
	ModifyGraph minor(bottom)=1
	SetAxis/A/N=1 responseLeft
	Label responseLeft "response (dB)"
	ControlBar 76
	SetVariable m2b_b1e,pos={14,6},size={211,17},proc=MPR_m2b,title="End of First Band"
	SetVariable m2b_b1e,limits={0,fs/2,df},value= root:Packages:WM_IFDL:m2b_b1e_fs
	SetVariable m2b_b2s,pos={240,8},size={242,17},proc=MPR_m2b,title="Start of Second Band"
	SetVariable m2b_b2s,limits={0,fs/2,df},value= root:Packages:WM_IFDL:m2b_b2s_fs
	PopupMenu m2b_lphp,pos={11,49},size={158,19},proc=m2bTypePopup,title="Filter Type"
	PopupMenu m2b_lphp,mode=lphp,popvalue=popMenuValue,value=#"\"low pass;high pass\""
	SetVariable m2b_b1w,pos={13,26},size={212,17},title="First Band Weighting"
	SetVariable m2b_b1w,limits={0.001,Inf,0.5},value= root:Packages:WM_IFDL:m2b_b1w
	SetVariable m2b_n,pos={240,27},size={242,17},title="Number of Terms"
	SetVariable m2b_n,limits={5,9999,1},value= root:Packages:WM_IFDL:m2b_n
	CheckBox dbCheck,pos={212,52},size={110,15},proc=m2bDbCheck,title="dB Response",value=1
	Button m2bCompute,pos={352,49},size={109,20},proc=m2bComputeButton,title="Compute Filter"
	Textbox/N=m2bLegend/X=0.99/Y=34.30 ""
	m2bLegend()
	SetWindow WMMPR2BandDesign, hook=designHook
	return 0
End

Function m2bDbCheck(ctrlName,checked) : CheckBoxControl
	String ctrlName
	Variable checked

	dBCheck(checked)
	MPR2BandUpdate()
	m2bLegend()
End

Function m2bTypePopup(ctrlName,popNum,popStr) : PopupMenuControl
	String ctrlName
	Variable popNum	// which item is currently selected (1-based)
	String popStr		// contents of current popup item as string

	NVAR lphp= root:Packages:WM_IFDL:m2b_lphp
	lphp= popNum
	MPR2BandUpdate()
End


Function MPR_m2b(ctrlName,varNum,varStr,varName) : SetVariableControl
	String ctrlName
	Variable varNum
	String varStr
	String varName

	MPR2BandUpdate()
End

Function m2bLegend()
	DesignLegend("WMMPR2BandDesign","m2b","m2bLegend")
End

Proc m2bComputeButton(ctrlName) : ButtonControl
	String ctrlName

	Silent 1;PauseUpdate
	String dfSav= Set_IFDL_DataFolder()

	Variable lphp= m2b_lphp
	Variable b1endFs= m2b_b1e_fs
	Variable b2startFs= m2b_b2s_fs
	Variable b1weight= m2b_b1w
	Variable nt= m2b_n
	SetDataFolder dfSav
	if( nt > 9999 )
		Abort "Too many filter terms. Max is 9999."
	endif 
	String/G root:Packages:WM_IFDL:proposedFilterName="mpr2Band"
	PMPR2BandNoShow(lphp==1,nt,b1endFs,b2startFs,b1weight)
	DoWindow/F WMMPR2BandDesign
	CheckDisplayed/W=WMMPR2BandDesign root:Packages:WM_IFDL:coefsMag,root:Packages:WM_IFDL:coefsDbMag
	if( V_Flag == 0 )
		ControlInfo/W=WMMPR2BandDesign dbCheck
		Variable wantDB= V_value
		Append/L=responseLeft $responseName(wantDB,1)
		String traceName= responseName(wantDB,0)
		ModifyGraph rgb($traceName)=(0,0,65535)
		ReorderTraces m2b_response, {$traceName}	// put actual response under desired response
	endif
	AppendPassDetails("detailsLeft",root:Packages:WM_IFDL:magPassDetails)	// appends /L=detailsLeft
	MPR2BandUpdate()
	AutoApplyFilter()
	m2bLegend()	// brings the design window back up, which is Good
end
